CREATE PROCEDURE stoVendas
(
    @DATAINI AS DATETIME,
    @DATAFIM AS DATETIME
)
AS
BEGIN
    SELECT      CONVERT(VARCHAR, CAST(ORDERDATE AS DATETIME), 103) ORDERDATE,
                ORDERS.ORDERID, EMPLOYEES.EMPLOYEEID, EMPLOYEES.TITLE, 
                EMPLOYEES.TITLEOFCOURTESY + ' ' + EMPLOYEES.FIRSTNAME + ' ' + EMPLOYEES.LASTNAME EMPLOYEE,
                 PRODUCTS.PRODUCTID, PRODUCTS.PRODUCTNAME,
                [ORDER DETAILS].UNITPRICE, [ORDER DETAILS].QUANTITY, [ORDER DETAILS].DISCOUNT,
                ([ORDER DETAILS].QUANTITY * [ORDER DETAILS].UNITPRICE) - 
                 ([ORDER DETAILS].QUANTITY *[ORDER DETAILS].DISCOUNT) VALUE
    FROM        ORDERS                      WITH(NOLOCK)
    INNER JOIN  [ORDER DETAILS]             WITH(NOLOCK)
    ON          ORDERS.ORDERID              = [ORDER DETAILS].ORDERID
    INNER JOIN  PRODUCTS                    WITH(NOLOCK)
    ON          [ORDER DETAILS].PRODUCTID    = PRODUCTS.PRODUCTID
    INNER JOIN  EMPLOYEES                   WITH(NOLOCK)
    ON          ORDERS.EMPLOYEEID           = EMPLOYEES.EMPLOYEEID
    WHERE       ORDERS.ORDERDATE            BETWEEN @DATAINI AND @DATAFIM
END

--SAMPLE stoVendas '1996-07-01 00:00:00', '1996-12-31 23:59:59'